package ru.yandex.solomon.experiments.gordiychuk;

import java.util.Optional;

import ru.yandex.misc.cmdline.CmdLineArgs;
import ru.yandex.misc.cmdline.Parameter;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.api.EProjectId;
import ru.yandex.stockpile.server.SnapshotLevel;


/**
 * @author Vladimir Gordiychuk
 */
@CmdLineArgs
public class StockpileSumpMetricsArgs {
    @Parameter(names = "--cluster", description = "source")
    public SolomonCluster cluster;

    public Optional<SnapshotLevel> level = Optional.empty();

    @Parameter(description = "shard for dump")
    public int shardId;

    @Parameter(names = "--type", description = "Dumpling type")
    public Optional<MetricType> type = Optional.empty();

    @Parameter(names = "--project", description = "Dumpling project")
    public Optional<EProjectId> projectId = Optional.empty();

    @Parameter(names = "--dir", description = "target dir")
    public String dir;
}
