package ru.yandex.solomon.experiments.gordiychuk;

import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.bits.HeapBitBuf;
import ru.yandex.solomon.codec.compress.VarintEncoder;

/**
 * @author Vladimir Gordiychuk
 */
@Fork(value = 1)
@Measurement(iterations = 20, batchSize = 30)
@Warmup(iterations = 10, batchSize = 30)
@State(Scope.Thread)
@Threads(1) //current test not support concurrent execution
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.NANOSECONDS)
public class VarIntEncoderJmh {

    /*
// value 0
Benchmark                       Mode  Cnt    Score   Error  Units
VarIntEncoderJmh.writeVarint64  avgt   20  219.408 ± 3.387  ns/op

Benchmark                       Mode  Cnt    Score   Error  Units
VarIntEncoderJmh.writeVarint64  avgt   20  147.247 ± 5.891  ns/op

// value 5
Benchmark                       Mode  Cnt    Score    Error  Units
VarIntEncoderJmh.writeVarint64  avgt   20  358.530 ± 34.065  ns/op

Benchmark                       Mode  Cnt    Score    Error  Units
VarIntEncoderJmh.writeVarint64  avgt   20  245.281 ± 12.833  ns/op

     */

    private long longValue;
    private BitBuf bitBuf;

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(VarIntEncoderJmh.class.getName())
            .detectJvmArgs()
            .jvmArgsAppend("-Dio.netty.buffer.checkBounds=true")
            .addProfiler(AsyncProfiler.class)
            .build();

        new Runner(opt).run();
    }

    @Setup
    public void prepare() {
        bitBuf = new HeapBitBuf(new byte[1024 << 20], 0); // 1024 Mib
    }

    @Setup(Level.Iteration)
    public void resetIndex() {
        bitBuf.resetWriterIndex();
        longValue = 5;
    }

    @Benchmark
    public Object writeVarint64() {
        VarintEncoder.writeVarintMode64(bitBuf, longValue);
        return bitBuf;
    }
}
