package ru.yandex.solomon.experiments.gordiychuk.grid;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.stockpile.client.shard.StockpileShardId;

import static ru.yandex.solomon.experiments.gordiychuk.grid.IoUtils.ls;

/**
 * @author Vladimir Gordiychuk
 */
public class EstimationReader {
    private final Path root;

    public EstimationReader(Path root) {
        this.root = root;
    }

    private Estimation parseLine(int shardId, String line) {
        int localId = line.indexOf('|');
        int min = line.indexOf('|', localId + 1);
        int max = line.indexOf('|', min + 1);
        int mean = line.indexOf('|', max + 1);
        int dominant = line.indexOf('|', mean + 1);

        var result = new Estimation();
        result.shardId = shardId;
        result.localId = Long.parseUnsignedLong(line, 0, localId, 10);
        result.min = Long.parseLong(line, localId + 1, min, 10);
        result.max = Long.parseLong(line, min + 1, max, 10);
        result.mean = Double.parseDouble(line.substring(max + 1, mean));
        result.std = Double.parseDouble(line.substring(mean + 1, dominant));
        result.dominant = Long.parseLong(line, dominant + 1, line.length(), 10);
        return result;
    }

    public boolean hasEstimation(int numId) {
        return Files.exists(estimationDir(numId));
    }

    public List<Estimation> read(int numId) {
        return ls(estimationDir(numId))
                .parallelStream()
                .flatMap(path -> readEstimations(path).stream())
                .collect(Collectors.toList());
    }

    private Path estimationDir(int numId) {
        return root.resolve("result").resolve(Integer.toUnsignedString(numId));
    }

    private List<Estimation> readEstimations(Path path) {
        int shardId = StockpileShardId.parse(path.getFileName().toString());
        try (var reader = IoUtils.gzReader(path);
             var stream = reader.lines())
        {
            return stream
                    .map(line -> parseLine(shardId, line))
                    .collect(Collectors.toList());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
