package ru.yandex.solomon.experiments.gordiychuk.grid;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import ru.yandex.solomon.experiments.gordiychuk.recovery.stockpile.StockpileShardReader;
import ru.yandex.stockpile.client.shard.StockpileShardId;
import ru.yandex.stockpile.kikimrKv.ShardIdMapToLong;
import ru.yandex.stockpile.server.SnapshotLevel;

/**
 * @author Vladimir Gordiychuk
 */
public class Estimator {
    private final Executor executor;
    private final StockpileShardReader reader;
    private final ShardIdMapToLong mapping;
    private final Path path;

    public Estimator(Executor executor, StockpileShardReader reader, ShardIdMapToLong mapping, Path path) {
        this.executor = executor;
        this.reader = reader;
        this.mapping = mapping;
        this.path = path;
    }

    public CompletableFuture<Void> run(int shardId) {
        long tabletId = mapping.get(shardId);
        Path file = path.resolve(StockpileShardId.toString(shardId));
        EstimationWriter writer = new EstimationWriter(file, executor);
        return reader.makeBackup(tabletId)
                .thenCompose(ignore -> reader.metricsIterator(tabletId, SnapshotLevel.DAILY, true))
                .thenCompose(it -> new EstimationActor(shardId, it, writer::enqueue, executor).run())
                .thenCompose(ignore -> reader.dropBackup(tabletId))
                .thenCompose(ignore -> writer.done())
                .whenComplete((ignore, e) -> {
                    writer.close();
                    if (e != null) {
                        reader.dropBackup(tabletId).join();
                    } else {
                        System.out.println("Success estimate shardId " + shardId);
                    }
                });
    }
}
