package ru.yandex.solomon.experiments.gordiychuk.grid;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author Vladimir Gordiychuk
 */
public class IoUtils {
    public static BufferedReader gzReader(Path path) {
        try {
            var in = Files.newInputStream(path, StandardOpenOption.READ);
            var gzip = new GZIPInputStream(in, 65536);
            var inr = new InputStreamReader(gzip, StandardCharsets.UTF_8);
            return new BufferedReader(inr);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedWriter gzWriter(Path path) {
        try {
            var fout = Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            var gzip = new GZIPOutputStream(fout);
            var ow = new OutputStreamWriter(gzip, StandardCharsets.UTF_8);
            return new BufferedWriter(ow);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void mkdir(Path path) {
        try {
            Files.createDirectories(path);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void rm(Path path) {
        try {
            Files.deleteIfExists(path);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Path> ls(Path path) {
        try (var stream = Files.list(path)) {
            return stream.collect(Collectors.toList());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
