package ru.yandex.solomon.experiments.gordiychuk.processing;

import java.util.concurrent.CompletableFuture;
import java.util.stream.LongStream;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.solomon.slog.Log;

/**
 * @author Vladimir Gordiychuk
 */
public class LogWriters implements AutoCloseable {
    private final KikimrKvClient kvClient;
    private final String path;
    private final LogWriter[] writers;

    public LogWriters(KikimrKvClient kvClient, String path) {
        this.kvClient = kvClient;
        this.path = path;
        var tables = kvClient.resolveKvTablets(path).join();
        if (tables.length == 0) {
            throw new IllegalStateException("Unable to resolve tables by kv path: " + path);
        }
        this.writers = LongStream.of(tables)
            .mapToObj(tableId -> new LogWriter(tableId, kvClient))
            .toArray(LogWriter[]::new);
    }

    public CompletableFuture<Void> enqueue(int numId, Log entry) {
        int index = (writers.length - 1) & hash(numId);
        return writers[index].enqueue(entry);
    }

    private int hash(int numId) {
        int h = Integer.hashCode(numId);
        return h ^ (h >>> 16);
    }

    @Override
    public void close() {
        for (var writer : writers) {
            writer.close();
        }
    }
}
