package ru.yandex.solomon.experiments.gordiychuk.recovery;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.tool.stockpile.Metric;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileMetricId;

/**
 * @author Vladimir Gordiychuk
 */
public class MappingRecord {
    public long localLocalId;
    public int remoteShardId;
    public long remoteLocalId;

    public MappingRecord() {
    }

    public MappingRecord(int remoteShardId, long remoteLocalId) {
        this.localLocalId = remoteLocalId;
        this.remoteShardId = remoteShardId;
        this.remoteLocalId = remoteLocalId;
    }

    public static MappingRecord parse(String line) {
        MappingRecord record = new MappingRecord();
        String[] columns = StringUtils.split(line, '|');
        record.localLocalId = Long.parseUnsignedLong(columns[0]);
        record.remoteShardId = Integer.parseInt(columns[1]);
        record.remoteLocalId = Long.parseUnsignedLong(columns[2]);
        return record;
    }

    public static MappingRecord of(Record local, Record remote) {
        var record = new MappingRecord();
        record.localLocalId = local.localId;
        record.remoteShardId = remote.shardId;
        record.remoteLocalId = remote.localId;
        return record;
    }

    public MappingRecord map(Record local, Record remote) {
        this.localLocalId = local.localId;
        this.remoteShardId = remote.shardId;
        this.remoteLocalId = remote.localId;
        return this;
    }

    public Metric toMetric(MetricArchiveImmutable archive) {
        return new Metric(remoteShardId, remoteLocalId, archive);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null) return false;
        if (!(o instanceof MappingRecord)) return false;

        MappingRecord that = (MappingRecord) o;

        if (localLocalId != that.localLocalId) return false;
        if (remoteShardId != that.remoteShardId) return false;
        return remoteLocalId == that.remoteLocalId;
    }

    @Override
    public int hashCode() {
        int result = 31 * (int) (localLocalId ^ (localLocalId >>> 32));
        result = 31 * result + remoteShardId;
        result = 31 * result + (int) (remoteLocalId ^ (remoteLocalId >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "MappingRecord{"
            + StockpileLocalId.toString(localLocalId)
            + " => "
            + StockpileMetricId.toString(remoteShardId, remoteLocalId)
            + '}';
    }
}
