package ru.yandex.solomon.experiments.gordiychuk.recovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * @author Vladimir Gordiychuk
 */
public class MappingRecordIterator implements AutoCloseable {
    private Path file;
    private long totalBytes;
    private long readBytes;
    private int readLines;
    private BufferedReader reader;

    public MappingRecordIterator(Path file) {
        this.file = file;
        this.totalBytes = file.toFile().length();
        try {
            this.reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
        } catch (NoSuchFileException e) {
            this.reader = new BufferedReader(new Reader() {
                @Override
                public int read(@Nonnull char[] cbuf, int off, int len) {
                    return -1;
                }

                @Override
                public void close() {
                }
            });
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public MappingRecord next() {
        try {
            String line = reader.readLine();
            if (line == null || line.isEmpty()) {
                return null;
            }

            readBytes += line.length();
            readLines++;

            if ((readLines % 100_000) == 0) {
                double progress = readBytes * 100. / totalBytes;
                System.out.println("Read file " + file + " " + String.format("%.2f%%", progress));
            }

            return MappingRecord.parse(line);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            reader.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
