package ru.yandex.solomon.experiments.gordiychuk.recovery;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;

import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.stockpile.client.shard.StockpileLocalId;

/**
 * @author Vladimir Gordiychuk
 */
public class MappingWriter implements AutoCloseable {
    private final Path path;
    private final Writer mapping;
    private long writeLines;

    public MappingWriter(Path path) {
        try {
            this.path = path;
            this.mapping = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(MappingRecord record) {
        try {
            StringBuilder line = new StringBuilder(50);
            append(line, record);
            mapping.write(line.toString());

            if ((++writeLines % 100_000) == 0) {
                System.out.println("Write file " + path + " " + DataSize.shortString(writeLines));
            }

        } catch (IOException e) {
            throw new RuntimeException(path.toString(), e);
        }
    }

    public void writeAll(List<? extends MappingRecord> records) {
        try {
            StringBuilder lines = new StringBuilder(50 * records.size());
            for (var record : records) {
                append(lines, record);
            }
            mapping.write(lines.toString());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void append(StringBuilder out, MappingRecord record) {
        out.append(StockpileLocalId.toString(record.localLocalId));
        out.append('|');
        out.append(record.remoteShardId);
        out.append('|');
        out.append(StockpileLocalId.toString(record.remoteLocalId));
        out.append(System.lineSeparator());
    }

    @Override
    public void close() {
        try {
            mapping.flush();
            mapping.close();
            System.out.println("Write " + path + " done");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
