package ru.yandex.solomon.experiments.gordiychuk.recovery;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;

import ru.yandex.monlib.metrics.JvmThreads;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.labels.shard.ShardKey;
import ru.yandex.solomon.selfmon.jvm.JvmAllocations;
import ru.yandex.solomon.selfmon.ng.JvmMon;
import ru.yandex.solomon.selfmon.ng.NettyMon;
import ru.yandex.solomon.selfmon.ng.ProcSelfMon;
import ru.yandex.solomon.tool.migration.kv.MetricsPushClient;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricsPushScheduler {

    public static void schedulePush() {
        MetricRegistry registry = MetricRegistry.root();
        JvmMon.addAllMetrics(registry);
        NettyMon.addAllocatorMetrics(registry);
        JvmAllocations.addMetrics(registry);
        JvmThreads.addExecutorMetrics("ForkJoin", ForkJoinPool.commonPool(), registry);
        ProcSelfMon.addCpuTimeMetrics(registry);
        ProcSelfMon.addMemoryMetrics(registry);
        ProcSelfMon.addThreadsMetrics(registry);
        MetricsPushClient.create().schedulePush(
            new ShardKey("solomon", "push", "push"),
            registry, 15, TimeUnit.SECONDS);
    }

}
