package ru.yandex.solomon.experiments.gordiychuk.recovery;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileShardId;

/**
 * @author Vladimir Gordiychuk
 */
public class Record implements Comparable<Record> {
    public String labels;
    public int shardId;
    public int flags;
    public long localId;
    public long createdAtSeconds;
    public int hash;

    public static Record parse(String line) {
        Record record = new Record();
        String[] columns = StringUtils.split(line, '|');
        record.labels = columns[0];
        record.flags = Integer.parseInt(columns[1]);
        record.shardId = Integer.parseInt(columns[2]);
        record.localId = Long.parseUnsignedLong(columns[3]);
        record.hash = record.labels.hashCode();
        return record;
    }

    public int getLabelsHashCode() {
        if (hash == 0) {
            hash = labels.hashCode();
        }
        return hash;
    }

    @Override
    public int compareTo(Record that) {
        int compare = Integer.compareUnsigned(this.getLabelsHashCode(), that.getLabelsHashCode());
        if (compare != 0) {
            return compare;
        }

        return labels.compareTo(that.labels);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Record record = (Record) o;

        if (shardId != record.shardId) return false;
        if (flags != record.flags) return false;
        if (localId != record.localId) return false;
        return labels != null ? labels.equals(record.labels) : record.labels == null;
    }

    @Override
    public int hashCode() {
        int result = labels != null ? labels.hashCode() : 0;
        result = 31 * result + shardId;
        result = 31 * result + flags;
        result = 31 * result + (int) (localId ^ (localId >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return "Record{" +
            "labels='" + labels + '\'' +
            ", shardId=" + StockpileShardId.toString(shardId) +
            ", localId=" + StockpileLocalId.toString(localId) +
            ", flags=" + flags +
            ", createdAtSeconds=" + createdAtSeconds +
            '}';
    }
}
