package ru.yandex.solomon.experiments.gordiychuk.recovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.misc.dataSize.DataSize;

/**
 * @author Vladimir Gordiychuk
 */
public class RecordIterator implements AutoCloseable {
    public final Path file;
    private final BufferedReader reader;
    private long readLines;

    public RecordIterator(Path file) {
        try {
            this.file = file;
            if (file.toFile().length() == 0) {
                this.reader = new BufferedReader(new Reader() {
                    @Override
                    public int read(@Nonnull char[] cbuf, int off, int len) {
                        return -1;
                    }

                    @Override
                    public void close() {
                    }
                });
            } else {
                var in = Files.newInputStream(file, StandardOpenOption.CREATE);
                var gzip = new GZIPInputStream(in, 65536);
                var reader = new InputStreamReader(gzip, StandardCharsets.UTF_8);
                this.reader = new BufferedReader(reader);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Record next() {
        String line = null;
        try {
            line = reader.readLine();
            if (line == null || line.isEmpty()) {
                return null;
            }

            if ((++readLines % 1_000_000) == 0) {
                System.out.println("Read file " + file + " " + DataSize.shortString(readLines));
            }

            return Record.parse(line);
        } catch (Throwable e) {
            throw new RuntimeException(file.toString() + " at line " + readLines + " with " + line, e);
        }
    }

    @Override
    public void close() {
        try {
            reader.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
