package ru.yandex.solomon.experiments.gordiychuk.recovery;

import java.util.Arrays;

import ru.yandex.solomon.experiments.gordiychuk.recovery.stockpile.StockpileRecoveryTask;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.client.shard.StockpileShardId;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileRecovery {

    // PROD_STORAGE_SAS PROD_STORAGE_VLA local
    public static void main(String[] args) {
        try {
            MetricsPushScheduler.schedulePush();
            SolomonCluster from = SolomonCluster.valueOf(args[0]);
            SolomonCluster to = SolomonCluster.valueOf(args[1]);

            try(var task = new StockpileRecoveryTask(from, to)) {
                String target = args[2];
                if ("local".equals(target)) {
                    task.recoveryLocalShards().join();
                } else {
                    int shardId = StockpileShardId.parse(target);
                    task.recoveryShard(shardId).join();
                }
            }

            System.out.println("Success: " + Arrays.toString(args));
            System.exit(0);
        } catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}
