package ru.yandex.solomon.experiments.gordiychuk.recovery.graphite;

import java.nio.file.Path;

import ru.yandex.solomon.experiments.gordiychuk.recovery.AsyncMappingWriters;
import ru.yandex.solomon.experiments.gordiychuk.recovery.Record;
import ru.yandex.solomon.tool.YdbClient;
import ru.yandex.solomon.tool.YdbHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;

/**
 * @author Vladimir Gordiychuk
 */
public class DumpMetricsFromGraphiteTask implements AutoCloseable {
    private final YdbClient ydb;
    private final AsyncMappingWriters one;
    private final AsyncMappingWriters two;

    public DumpMetricsFromGraphiteTask(Path root, SolomonCluster one, SolomonCluster two) {
        this.ydb = YdbHelper.createYdbClient(SolomonCluster.PROD_FRONT);
        this.one = new AsyncMappingWriters(mapping(one, root));
        this.two = new AsyncMappingWriters(mapping(two, root));
    }

    private static Path mapping(SolomonCluster cluster, Path root) {
        return root.resolve(cluster.name().toLowerCase());
    }

    public void run() {
        read("/Kfront/MegaGraphite/BS/Metrics");
        read("/Kfront/MegaGraphite/GR/Metrics");
        read("/Kfront/MegaGraphite/PS/Metrics");
        ydb.close();
    }

    public void read(String path) {
        GraphiteMetricsReader reader = new GraphiteMetricsReader(ydb);
        Record record = new Record();
        reader.read(path, (name, shardId, localId) -> {
            record.shardId = shardId;
            record.localId = localId;

            one.map(record, record).join();
            two.map(record, record).join();
        }).join();
    }

    @Override
    public void close() {
        ydb.close();
        one.close();
        two.close();
    }
}
