package ru.yandex.solomon.experiments.gordiychuk.recovery.metabase;

import java.nio.file.Path;
import java.util.concurrent.ExecutorService;

import ru.yandex.solomon.tool.cfg.SolomonCluster;

/**
 * @author Vladimir Gordiychuk
 */
public class DumpMetricsFromMetabaseTask {
    private final ExecutorService executor;
    private final Path root;

    public DumpMetricsFromMetabaseTask(ExecutorService executor, Path root) {
        this.executor = executor;
        this.root = root;
    }

    public void run(SolomonCluster cluster) {
        System.out.println("Start dumping metabase " + cluster);
        var path = start(cluster);
        System.out.println("Success dump metabase to dir " + path);
    }

    private Path start(SolomonCluster cluster) {
        var task = new DumpMetricsFromClusterTask(cluster, executor, root);
        task.run();

        return root.resolve(cluster.name().toLowerCase());
    }
}
