package ru.yandex.solomon.experiments.gordiychuk.recovery.metabase;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

import ru.yandex.solomon.experiments.gordiychuk.recovery.AsyncRecordWriter;
import ru.yandex.solomon.tool.YdbClient;

/**
 * @author Vladimir Gordiychuk
 */
public class DumpMetricsFromShardTask {
    private static final long SENSOR_AGE_FILTER = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - TimeUnit.DAYS.toSeconds(7);

    private final MetabaseShardMetricsReader reader;
    private final AsyncRecordWriter writer;

    public DumpMetricsFromShardTask(String root, YdbClient client, String shardId, Executor executor, Path file) {
        this.reader = new MetabaseShardMetricsReader(root, client, shardId, SENSOR_AGE_FILTER);
        this.writer = new AsyncRecordWriter(file, executor);
    }

    public CompletableFuture<Void> run() {
        var writeFuture = writer.doneFuture();
        var readFuture = reader.run(writer::add).thenRun(writer::complete);
        return CompletableFuture.allOf(readFuture, writeFuture);
    }
}
