package ru.yandex.solomon.experiments.gordiychuk.recovery.stockpile;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.util.NameRange;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.kikimrKv.ShardIdMapToLong;
import ru.yandex.stockpile.server.shard.load.Async;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileCheckNotReadyShards {

    public static void main(String[] args) {
        var cluster = SolomonCluster.PROD_STORAGE_SAS;
        KikimrKvClient kvClient = KikimrHelper.createKvClient(cluster);

        var mapping = kvClient.resolveKvTablets(cluster.getSolomonVolumePath())
            .thenApply(ShardIdMapToLong::new)
            .join();

        var cursorIt = mapping.shardIdStream().iterator();
        AtomicInteger notReady = new AtomicInteger();
        Async.forEach(() -> {
            if (!cursorIt.hasNext()) {
                return CompletableFuture.completedFuture(null);
            }
            int shardId = cursorIt.nextInt();

            long tabletId = mapping.get(shardId);
            return kvClient.readRangeNames(tabletId, 0, NameRange.single("mapping"), expiredAt())
                .thenApply(result -> {
                    if (result.isEmpty()) {
                        return 0;
                    } else {
                        System.out.println("ShardId " + shardId);
                        return 1;
                    }
                });
        }, notReady::addAndGet).join();

        System.out.println("Count not ready: " + notReady.get());
        System.exit(0);
    }

    private static long expiredAt() {
        return System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1);
    }
}
