package ru.yandex.solomon.experiments.gordiychuk.recovery.stockpile;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.util.future.RetryConfig;
import ru.yandex.stockpile.kikimrKv.counting.KikimrKvClientCounting;
import ru.yandex.stockpile.kikimrKv.counting.ReadClass;
import ru.yandex.stockpile.server.data.chunk.ChunkWithNo;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.index.SnapshotIndex;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;
import ru.yandex.stockpile.server.data.names.StockpileKvNames;
import ru.yandex.stockpile.server.shard.iter.KvSnapshotChunkIterator;

import static ru.yandex.solomon.util.future.RetryCompletableFuture.runWithRetries;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileSnapshotChunkIterator extends KvSnapshotChunkIterator {
    private final long tabletId;
    private final FileNamePrefix prefix;
    private final SnapshotIndex snapshot;
    private final KikimrKvClientCounting kvClient;
    private final RetryConfig retryConfig;

    public StockpileSnapshotChunkIterator(
        long tabletId,
        FileNamePrefix prefix,
        SnapshotIndex snapshot,
        KikimrKvClientCounting kvClient,
        RetryConfig retryConfig)
    {
        super(snapshot.snapshotAddress(), snapshot.getContent().getChunksCount());
        this.tabletId = tabletId;
        this.prefix = prefix;
        this.snapshot = snapshot;
        this.kvClient = kvClient;
        this.retryConfig = retryConfig;
    }

    @Override
    protected CompletableFuture<ChunkWithNo> readNext(SnapshotAddress snapshotAddress, int chunkNo) {
        String file = StockpileKvNames.chunkFileName(snapshot.getLevel(), snapshot.getTxn(), chunkNo, prefix);
        return runWithRetries(() -> kvClient.readDataLarge(ReadClass.MERGE_READ_CHUNK, tabletId, 0, file), retryConfig)
            .thenApply(bytes -> new ChunkWithNo(chunkNo, bytes));
    }
}
