#!/bin/bash

## Check ydb cli is working

# PREPROD on gateway
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scheme ls

# CLOUD-PROD on gateway
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scheme ls

# TESTING on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme ls

# PRESTABLE on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme ls

# PROD on gateway
kikimr db yql --text 'select 1'

## Add column

# PREPROD on gateway
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -s 'alter table [Config/V2/ServiceProvider] ADD COLUMN referenceSettings Utf8;'

# CLOUD-PROD on gateway
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -s 'alter table [Config/V2/ServiceProvider] ADD COLUMN referenceSettings Utf8;'

# TESTING on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'alter table [Config/V2/ServiceProvider] ADD COLUMN referenceSettings Utf8;'

# PRESTABLE on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'alter table [Config/V2/ServiceProvider] ADD COLUMN referenceSettings Utf8;'

# PROD
kikimr db yql --text 'alter table [/Kfront/Solomon/Config/V2/ServiceProvider] ADD COLUMN referenceSettings Utf8;'

## Add service meta
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -f query.sql


# sync serverless-functions CLOUD PROD
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -f ydb_sync_service_provider_serverless-functions.sql

# sync serverless_triggers_client_metrics CLOUD PROD
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -f ydb_sync_service_provider_serverless_triggers_client_metrics.sql

# read table
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    table readtable Config/V2/Shard --format json-unicode > shards.json
