package ru.yandex.solomon.experiments.jamel;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.client.kv.KvReadRangeResult;
import ru.yandex.kikimr.util.NameRange;
import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.config.protobuf.stockpile.EInvalidArchiveStrategy;
import ru.yandex.solomon.tool.KikimrHelper;
import ru.yandex.solomon.tool.cfg.SolomonCluster;
import ru.yandex.stockpile.server.data.names.StockpileKvNames;
import ru.yandex.stockpile.server.shard.InvalidArchiveStrategy;
import ru.yandex.stockpile.server.shard.load.Async;
import ru.yandex.stockpile.server.shard.load.KvLogParsingIterator;
import ru.yandex.stockpile.server.shard.load.KvReadRangeIterator;
import ru.yandex.stockpile.server.shard.load.MetricArchivesMerger;

import static ru.yandex.misc.concurrent.CompletableFutures.join;


/**
 * @author Sergey Polovko
 */
public class AsyncRangeIteratorTest {

    public static void main(String[] args) {
        String path = args[0];
        try (KikimrKvClient client = KikimrHelper.createKvClient(SolomonCluster.DEV_MYT)) {
            long tabletId = join(client.resolveKvTablets(path))[0];

            ExecutorService executor = ForkJoinPool.commonPool();

            KvLogParsingIterator it = new KvLogParsingIterator(
                executor,
                EInvalidArchiveStrategy.FAIL,
                new KvReadRangeIterator(StockpileKvNames.logRange()) {
                    @Override
                    protected CompletableFuture<KvReadRangeResult> readNext(NameRange nameRange) {
                        return client.readRange(tabletId, 0, nameRange, true, 0);
                    }
                });

            MetricArchivesMerger merger = new MetricArchivesMerger(42, InvalidArchiveStrategy.fail(), executor, 16);

            long start = System.currentTimeMillis();
            Async.forEachAsync(it, logEntry -> {
                Long2ObjectMap<MetricArchiveImmutable> metrics = logEntry.getDataByMetricId();
                System.out.println("parsed " + metrics.size() + " metrics");
                return merger.merge(metrics);
            }).join();

            System.out.println("elapsed: " + (System.currentTimeMillis() - start) + " ms");
            System.out.println("total " + merger.combineResults().size() + " metrics");
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}
