package ru.yandex.solomon.experiments.jamel;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import yandex.cloud.auth.api.Resource;
import yandex.cloud.auth.api.Subject;
import yandex.cloud.auth.api.credentials.IamToken;
import yandex.cloud.auth.grpc.internal.AsyncCloudAuthGrpcClientImpl;


/**
 * Before run do this:
 *
 * $ ssh -L 4286:as.private-api.cloud-preprod.yandex.net:4286 solomon-gateway-00.svc.cloud-preprod.yandex.net
 * $ echo '::1 as.private-api.cloud-preprod.yandex.net' >> /etc/hosts
 *
 * @author Sergey Polovko
 */
public class IamTool {

    public static void main(String[] args) {
        String token = System.getenv("TOKEN");
        String cloudId = System.getenv("CLOUD_ID");

        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        ManagedChannel channel = ManagedChannelBuilder.forAddress("as.private-api.cloud-preprod.yandex.net", 4286)
            .userAgent("Solomon")
            .enableRetry()
            .maxRetryAttempts(2)
            .build();

        try {
            Duration readTimeout = Duration.ofSeconds(2);
            var client = new AsyncCloudAuthGrpcClientImpl(channel, readTimeout, threadPool);

            Subject subject = client.authorize(
                new IamToken(token),
                "monitoring.data.write",
                Resource.cloud(cloudId)).join();

            System.out.println(subjectToString(subject));
        } finally {
            channel.shutdown();
            threadPool.shutdown();
        }
    }

    private static String subjectToString(Subject subject) {
        if (subject instanceof Subject.ServiceAccount) {
            Subject.ServiceAccount account = (Subject.ServiceAccount) subject;
            return "service account {" +
                    "folderId: " + account.getFolderId() + ", " +
                    "id: " + ((Subject.ServiceAccount.Id) account.toId()).getId() +
                "}";
        }
        if (subject instanceof Subject.UserAccount) {
            Subject.UserAccount account = (Subject.UserAccount) subject;
            return "service account {" +
                    "id: " + ((Subject.UserAccount.Id) account.toId()).getId() +
                "}";
        }
        if (subject instanceof Subject.Anonymous) {
            return "anonymous";
        }
        return "unknown subject type: " + subject;
    }
}
