package ru.yandex.solomon.experiments.jamel;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.config.WebFluxConfigurer;

import ru.yandex.solomon.auth.Account;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.Authenticator;
import ru.yandex.solomon.auth.http.HttpAuthenticator;
import ru.yandex.solomon.auth.internal.InternalAuthorizer;
import ru.yandex.solomon.config.protobuf.ELevel;
import ru.yandex.solomon.config.protobuf.TLogger;
import ru.yandex.solomon.config.protobuf.TLoggingConfig;
import ru.yandex.solomon.config.protobuf.TThreadPoolConfig;
import ru.yandex.solomon.config.protobuf.TThreadPoolType;
import ru.yandex.solomon.config.protobuf.TThreadPoolsConfig;
import ru.yandex.solomon.config.protobuf.coremon.TCoremonConfig;
import ru.yandex.solomon.config.protobuf.http.HttpServerConfig;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.main.SolomonWebApp;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.secrets.SecretProviders;
import ru.yandex.solomon.staffOnly.StaffOnlyRedirectController;

/**
 * Damn simple application for faster Manager UI hacking.
 *
 * @author Sergey Polovko
 */
@Configuration
@Import({
    StaffOnlyRedirectController.class,
    LazyThreadPoolProvider.class,
    ManagerTestApp.FakeAuthContext.class,
    TestController.class,
})
public class ManagerTestApp extends SolomonWebApp {

    ManagerTestApp() {
        super(TCoremonConfig.getDefaultInstance());
    }

    @Override
    protected Message parseConfig(String[] args) {
        return TCoremonConfig.newBuilder()
            .setHttpServerConfig(HttpServerConfig.newBuilder()
                .setBind("localhost")
                .setPort(7000)
                .setThreadsCount(2))
            .setThreadPoolsConfig(TThreadPoolsConfig.newBuilder()
                .addThreadPools(threadPool("FirstThreadPool", 3))
                .addThreadPools(threadPool("SecondThreadPool", 2))
                .addThreadPools(threadPool("Io", 1))
                .addThreadPools(threadPool("Scheduler", 1)))
            .setLoggingConfig(TLoggingConfig.newBuilder()
                .addLoggers(TLogger.newBuilder()
                    .setLevel(ELevel.DEBUG)
                    .setName("root")))
            .build();
    }

    @Configuration
    public static class FakeAuthContext implements WebFluxConfigurer {

        @Bean
        HttpAuthenticator httpAuthenticator() {
            return new HttpAuthenticator(Authenticator.anonymous());
        }

        @Bean
        InternalAuthorizer internalAuthorizer() {
            return new InternalAuthorizer(Set.of()) {
                @Override
                public CompletableFuture<Account> authorize(AuthSubject subject) {
                    return CompletableFuture.completedFuture(Account.ANONYMOUS);
                }
            };
        }

        @Override
        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            configurer.defaultCodecs().maxInMemorySize(50 << 20);
        }
    }

    @Override
    protected SecretProvider parseSecrets(String[] args) {
        return SecretProviders.empty();
    }

    private static TThreadPoolConfig threadPool(String name, int threads) {
        return TThreadPoolConfig.newBuilder()
            .setName(name)
            .setThreads(threads)
            .setThreadPoolType(TThreadPoolType.GENERAL)
            .build();
    }

    public static void main(String[] args) {
        new ManagerTestApp().run(args);
    }
}
