package ru.yandex.solomon.experiments.jamel;

import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.stockpile.api.EDecimPolicy;
import ru.yandex.stockpile.api.EProjectId;
import ru.yandex.stockpile.client.writeRequest.StockpileShardWriteRequest;
import ru.yandex.stockpile.client.writeRequest.StockpileShardWriteRequestBuilder;

/**
 *
 * Benchmark                                                      Mode  Cnt      Score      Error   Units
 * StockpileShardWriteRequestSerializerBenchmark.deserializeNew  thrpt   10  11815.813 ±  652.167  ops/ms
 * StockpileShardWriteRequestSerializerBenchmark.deserializeOld  thrpt   10   3593.803 ±  209.301  ops/ms
 * StockpileShardWriteRequestSerializerBenchmark.serializeNew    thrpt   10  29274.766 ± 2136.848  ops/ms
 * StockpileShardWriteRequestSerializerBenchmark.serializeOld    thrpt   10   2548.666 ±   91.377  ops/ms
 *
 * @author Sergey Polovko
 */
@Fork(value = 1)
@Measurement(iterations = 10, time = 3, timeUnit = TimeUnit.SECONDS)
@Warmup(iterations = 5, time = 3, timeUnit = TimeUnit.SECONDS)
@State(Scope.Thread)
@Threads(1)
@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.MILLISECONDS)
public class StockpileShardWriteRequestSerializerBenchmark {

    private static final StockpileShardWriteRequest request = buildRequest();
    private static final byte[] buffer = request.serialize();

    private static StockpileShardWriteRequest buildRequest() {
        var b = new StockpileShardWriteRequestBuilder(EProjectId.SOLOMON, 42);
        short decimPolicyId = (short) EDecimPolicy.POLICY_5_MIN_AFTER_7_DAYS.getNumber();
        long nowMillis = System.currentTimeMillis();
        b.addRecord(1, AggrPoint.shortPoint(nowMillis, 3.14), decimPolicyId, MetricType.DGAUGE);
        b.addDeleteData(2);
        b.addDeleteDataWithTs(3, nowMillis);
        return b.build();
    }

    @Benchmark
    public byte[] serializeNew() {
        return request.serialize();
    }

    @Benchmark
    public StockpileShardWriteRequest deserializeNew() {
        return StockpileShardWriteRequest.deserialize(buffer);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(StockpileShardWriteRequestSerializerBenchmark.class.getName())
            .build();

        new Runner(opt).run();
    }
}
