package ru.yandex.solomon.experiments.prudent;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.YtUtils;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

/**
 * @author Nuradil Zhambyl
 */
public class AllClustersReader {

    private static void writeToFile(Set<String> set, String fileName) throws IOException {
        try (FileWriter fileWriter = new FileWriter(fileName);
             BufferedWriter writer = new BufferedWriter(fileWriter)) {
            boolean first = true;
            for (String cluster : set) {
                if (!first) {
                    writer.append('\n');
                }
                writer.append(cluster);
                first = false;
            }
        }
        System.out.printf("wrote to %s\n", fileName);
    }

    private static void readAllClusters() throws IOException {
        String ytAddress = "hahn.yt.yandex.net";
        String ytTable = "//home/solomon/service_provider_alerts/service_provider_exports/managed-postgresql";
        Yt yt = YtUtils.http(ytAddress);
        YPath table = YPath.simple(ytTable);
        var read = yt.tables().read(table, YTableEntryTypes.YSON);
        var list = read.stream().collect(Collectors.toList());
        Set<String> clusterNames = new HashSet<>();
        for (var row : list) {
            String clusterName = row.getString("global_id");
            clusterNames.add(clusterName);
        }
        writeToFile(clusterNames, "/Users/prudent/arcadia/solomon/misc/experiments/src/prudent/allClusters.txt");
    }

    public static void main(String[] args) throws IOException {
        readAllClusters();
    }
}
