package ru.yandex.solomon.experiments.prudent;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Nuradil Zhambyl
 */
public class ClusterNamesWriter {

    private static final String ALERTLESS_CLUSTERS = "/Users/prudent/arcadia/solomon/misc/experiments/src/prudent/clustersAlertless.txt";
    private static final String CLUSTER_NAMES = "/Users/prudent/arcadia/solomon/misc/experiments/src/prudent/clusterNames.txt";

    private static List<String> readFile(String fileName) throws IOException {
        Stream<String> stream = Files.lines(Paths.get(fileName));
        return stream.collect(Collectors.toList());
    }

    private static void writeToFile(List<String> list, String fileName) throws IOException {
        try (FileWriter fileWriter = new FileWriter(fileName);
             BufferedWriter writer = new BufferedWriter(fileWriter)) {
            boolean first = true;
            for (String cluster : list) {
                if (!first) {
                    writer.append('\n');
                }
                writer.append(cluster);
                first = false;
            }
        }
        System.out.printf("wrote to %s\n", fileName);
    }

    private static void assertSize(String[] args, int size) throws IllegalArgumentException {
        if (args.length < size) {
            throw new IllegalArgumentException(String.format("arguments size < %d", size));
        }
    }

    // example program arguments: 1 500
    // 1-indexed input
    public static void main(String[] args) throws IOException {
        assertSize(args, 2);
        int left = Integer.parseInt(args[0]);
        int right = Integer.parseInt(args[1]);
        List<String> alertlessClusters = readFile(ALERTLESS_CLUSTERS);
        left--;
        List<String> clusterNames = alertlessClusters.subList(left, right);
        writeToFile(clusterNames, CLUSTER_NAMES);
    }
}
