package ru.yandex.solomon.experiments.prudent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import io.grpc.ManagedChannel;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;

import ru.yandex.monitoring.api.v3.AlertConfig;
import ru.yandex.monitoring.api.v3.AlertParameter;
import ru.yandex.monitoring.api.v3.AlertingStubRequestServiceGrpc;
import ru.yandex.monitoring.api.v3.CompleteStubRequest;
import ru.yandex.monitoring.api.v3.CompleteStubRequestResponse;
import ru.yandex.monitoring.api.v3.CreateStubRequest;
import ru.yandex.monitoring.api.v3.CreateStubRequestResponse;
import ru.yandex.monitoring.api.v3.EvaluationStatus;
import ru.yandex.monitoring.api.v3.GetStubRequest;
import ru.yandex.monitoring.api.v3.MonitoringConfig;
import ru.yandex.monitoring.api.v3.NotificationChannel;
import ru.yandex.monitoring.api.v3.Resource;
import ru.yandex.solomon.experiments.alextrushkin.AuthCallCredentials;
import ru.yandex.solomon.util.Proto;

/**
 * @author Nuradil Zhambyl
 */
public class StubRequestV3Client {
    private final static String PROJECT_ID = "prudent_project_id";
    private final static String SERVICE_PROVIDER_ID = "managed-postgresql";
    private final static String TEMPLATE_ID_1 = "managed-postgresql-transaction-0.9";
    private final static String TEMPLATE_ID_2 = "managed-postgresql-net-usage";
    private final static String CHANNEL_ID = "prudent_channel_id";
    private final static String VALUE = "e64088b8-13cb-4771-9274-3e779efa1fdc";

    public static void main(String[] args) throws Exception {
        AuthCallCredentials credentials = AuthCallCredentials.asUser("prudent");
        var channel = localChannel();
        var client = AlertingStubRequestServiceGrpc
                .newBlockingStub(channel)
                .withCallCredentials(credentials);
        checkComplete(client, "190");
        checkComplete(client, "190");
    }

    private static void checkCreate(AlertingStubRequestServiceGrpc.AlertingStubRequestServiceBlockingStub client, String id) {
        var createOperation = client.create(dummyCreateStubRequest(id));
        if (createOperation.hasError()) {
            throw new IllegalArgumentException(createOperation.getError().getMessage());
        }
        var response = Proto.unpack(createOperation.getResponse(), CreateStubRequestResponse.class);
        System.out.println("create operation response id: " + response.getId());
    }

    private static void checkGet(AlertingStubRequestServiceGrpc.AlertingStubRequestServiceBlockingStub client, String id) {
        var response = client.get(dummyGetStubRequest(id));
        System.out.println("get response id: " + response.getId());
    }

    private static void checkComplete(AlertingStubRequestServiceGrpc.AlertingStubRequestServiceBlockingStub client, String id) {
        var completeOperation = client.complete(dummyCompleteStubRequest(id));
        if (completeOperation.hasError()) {
            throw new IllegalArgumentException(completeOperation.getError().getMessage());
        }
        var response = Proto.unpack(completeOperation.getResponse(), CompleteStubRequestResponse.class);
        System.out.println("complete operation response id: " + response.getId());
    }

    private static List<Resource> dummyResources() {
        Map<String, String> map = new HashMap<>();
        map.put("cluster", VALUE);
        List<Resource> list = new LinkedList<>();
        list.add(Resource
                .newBuilder()
                .putAllResourceParameters(map)
                .build());
        return list;
    }

    private static CompleteStubRequest dummyCompleteStubRequest(String id) {
        return CompleteStubRequest
                .newBuilder()
                .setId(id)
                .addAllResources(dummyResources())
                .build();
    }

    private static GetStubRequest dummyGetStubRequest(String id) {
        return GetStubRequest
                .newBuilder()
                .setId(id)
                .build();
    }

    private static List<AlertParameter> dummyAlertThresholds() {
        List<AlertParameter> alertThresholds = new LinkedList<>();
        return alertThresholds;
    }

    private static List<NotificationChannel> dummyNotificationChannels() {
        List<NotificationChannel> notificationChannels = new LinkedList<>();
        notificationChannels.add(dummyNotificationChannel(CHANNEL_ID));
        notificationChannels.add(dummyNotificationChannel(CHANNEL_ID));
        return notificationChannels;
    }

    private static EvaluationStatus dummyNotifyStatus() {
        return EvaluationStatus.EVALUATION_STATUS_WARN;
    }

    private static List<EvaluationStatus> dummyNotifyStatuses() {
        List<EvaluationStatus> statuses = new ArrayList<>();
        statuses.add(dummyNotifyStatus());
        return statuses;
    }

    private static NotificationChannel dummyNotificationChannel(String notificationId) {
        return NotificationChannel
                .newBuilder()
                .setNotificationChannelId(notificationId)
                .addAllNotifyAboutStatuses(dummyNotifyStatuses())
                .setRepeatNotifyDelayMs(400000)
                .build();
    }

    private static List<AlertConfig> dummyAlertConfigs() {
        List<AlertConfig> alertConfigs = new LinkedList<>();
        alertConfigs.add(dummyAlertConfig(TEMPLATE_ID_1));
        alertConfigs.add(dummyAlertConfig(TEMPLATE_ID_2));
        return alertConfigs;
    }

    private static AlertConfig dummyAlertConfig(String id) {
        return AlertConfig
                .newBuilder()
                .setAlertTemplateId(id)
                .addAllNotificationChannels(dummyNotificationChannels())
                .addAllAlertThresholds(dummyAlertThresholds())
                .build();
    }

    public static MonitoringConfig dummyStub() {
        return MonitoringConfig
                .newBuilder()
                .setProjectId(PROJECT_ID)
                .addAllAlertConfigs(dummyAlertConfigs())
                .setSeverityValue(3)
                .build();
    }

    private static CreateStubRequest dummyCreateStubRequest(String id) {
        return CreateStubRequest
                .newBuilder()
                .setId(id)
                .setServiceProviderId(SERVICE_PROVIDER_ID)
                .setStub(dummyStub())
                .build();
    }

    private static ManagedChannel localChannel() {
        return NettyChannelBuilder.forTarget("localhost:5740")
                .negotiationType(NegotiationType.PLAINTEXT)
                .build();
    }
}
