package ru.yandex.solomon.experiments.rorewillo;

import java.io.File;
import java.util.concurrent.Executor;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;

import ru.yandex.monitoring.v3.DashboardServiceGrpc;
import ru.yandex.monitoring.v3.ListDashboardRequest;
import ru.yandex.solomon.auth.AuthType;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ApiV3GrpcClient {

    private static class AuthCallCredentials extends CallCredentials {
        private final AuthType type;
        private final String token;

        private AuthCallCredentials(AuthType type, String token) {
            this.type = type;
            this.token = token;
        }

        @Override
        public void applyRequestMetadata(
                RequestInfo requestInfo,
                Executor appExecutor,
                MetadataApplier applier) {
            Metadata headers = new Metadata();
            String value;
            if (type.getValuePrefix().isEmpty()) {
                value = token;
            } else {
                value = type.getValuePrefix() + token;
            }

            headers.put(type.getMetadataKey(), value);

            applier.apply(headers);
        }

        @Override
        public void thisUsesUnstableApi() {
        }
    }

    public static void main(String[] args) throws Exception {
        String oauthToken = System.getenv("OAUTH_TOKEN");

        AuthCallCredentials credentials = new AuthCallCredentials(AuthType.OAuth, oauthToken);

        var sslContext = GrpcSslContexts.forClient().trustManager(new File("/home/rorewillo/.certs/allCAs.pem")).build();

        var channel = NettyChannelBuilder.forTarget("monitoring.private-api.cloud-preprod.yandex.net:443")
                .negotiationType(NegotiationType.TLS)
                .sslContext(sslContext)
                .build();

        var client = DashboardServiceGrpc.newBlockingStub(channel)
                .withCallCredentials(credentials);

        var listRequest = ListDashboardRequest.newBuilder().setProjectId("solomon").build();

        var response = client.list(listRequest);

        System.out.println("Response: " + response);
    }
}
