package ru.yandex.solomon.experiments.uranix;

import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

import ru.yandex.solomon.alert.protobuf.ResolvedEmptyPolicy;
import ru.yandex.solomon.alert.protobuf.TAlertServiceGrpc;
import ru.yandex.solomon.alert.protobuf.TReadAlertRequest;
import ru.yandex.solomon.alert.protobuf.TUpdateAlertRequest;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AlertingGrpcClient {

    private static void show(GeneratedMessageV3 response) {
        System.out.println(response.getClass().getSimpleName() + ": " + response.toString());
    }

    public static void main(String[] args) throws InterruptedException {
        ManagedChannel channel = ManagedChannelBuilder.forAddress("solomon-kfront-sas-00.search.yandex.net", 8799)
        //ManagedChannel channel = ManagedChannelBuilder.forAddress("localhost", 8799)
                .usePlaintext()
                .build();

        var stub = TAlertServiceGrpc.newBlockingStub(channel);

        var alert = stub.readAlert(TReadAlertRequest.newBuilder()
                .setProjectId("junk")
                .setAlertId("vpc_api_errors_testing")
                .build())
                .getAlert();

        alert = alert.toBuilder()
                .setResolvedEmptyPolicy(ResolvedEmptyPolicy.RESOLVED_EMPTY_OK)
                .build();

        stub.updateAlert(TUpdateAlertRequest.newBuilder()
                .setAlert(alert)
                .build());

        channel.shutdown().awaitTermination(5, TimeUnit.SECONDS);
    }
}
