package ru.yandex.solomon.experiments.uranix;

import java.time.Instant;
import java.util.List;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.monitoring.dataproxy.ReadManyRequest;
import ru.yandex.monitoring.dataproxy.ReadManyResponse;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.config.SolomonConfigs;
import ru.yandex.solomon.config.protobuf.frontend.TGatewayConfig;
import ru.yandex.solomon.config.thread.StubThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.dataproxy.client.DataProxyClient;
import ru.yandex.solomon.dataproxy.client.DataProxyClientFactory;
import ru.yandex.solomon.expression.analytics.Program;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.math.protobuf.Operation;
import ru.yandex.solomon.math.protobuf.OperationDownsampling;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class DataProxyTestClient {

    private static final String request = """
            {
                cluster="host_0", service="yasm", host="iva1-0058.search.yandex.net",
                ctype="prod", gencfg="MSK_YASM_PRODUCTION_DUMPER", geo="msk", nanny="production_yasmdumper_misc_msk_new",
                prj="yasm", replica="0", signal="cgroup-blkio_count_hgram", tier="none"
            }
            """;

    public static void main(String[] args) {
        ThreadPoolProvider threadPool = new StubThreadPoolProvider();
        ClientOptionsFactory clientOptionsFactory = new ClientOptionsFactory(Optional.empty(), Optional.empty(), threadPool);
        DataProxyClientFactory dataProxyClientFactory = new DataProxyClientFactory(
                threadPool, new MetricRegistry(), clientOptionsFactory);
        TGatewayConfig config = SolomonConfigs.parseConfig(
                "/home/uranix/arcadia/solomon/configs/prestable/gateway.conf",
                TGatewayConfig.getDefaultInstance());
        DataProxyClient client = dataProxyClientFactory.createClient("dataproxy-test-client",
                config.getDataProxyClientConfig());

        Instant now = Instant.now();
        List<Selectors> selectorsList = Program.fromSourceWithReturn(request, false)
                .compile()
                .getProgramSelectors();

        Selectors query = selectorsList.get(0);
        String converted = Selectors.format(query);
        Interval interval = new Interval(Instant.parse("2020-12-28T21:00:00Z"), Instant.parse("2020-12-29T00:00:00Z"));
        var req = ReadManyRequest.newBuilder()
                .setLookup(ReadManyRequest.Lookup.newBuilder()
                        .setSelectors(converted)
                        .setLimit(10000))
                .setProjectId("yasm_pull_sts1_yasmdumper")
                .setFromMillis(interval.getBeginMillis())
                .setToMillis(interval.getEndMillis())
                .setMaxTimeSeriesFormat(StockpileFormat.MAX.getFormat())
                .addOperations(Operation.newBuilder()
                        .setDownsampling(OperationDownsampling.newBuilder()
                                .setGridMillis(15_000)
                                .setFillOption(OperationDownsampling.FillOption.NONE)))
                .build();

        System.out.println(req);

        ReadManyResponse resp = client.readMany(req, now.plusSeconds(30).toEpochMilli()).join();

        System.out.println(resp);
    }
}
