package ru.yandex.solomon.experiments.uranix;

import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.Executor;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.CallCredentials;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import org.apache.commons.io.IOUtils;

import ru.yandex.monitoring.gateway.DataQuery;
import ru.yandex.monitoring.gateway.ReadDataRequest;
import ru.yandex.monitoring.gateway.YasmGatewayServiceGrpc;
import ru.yandex.solomon.auth.AuthType;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class MonitoringGrpcApiTest {

    private static class AuthCallCredentials extends CallCredentials {
        private final AuthType type;
        private final String token;

        private AuthCallCredentials(AuthType type, String token) {
            this.type = type;
            this.token = token;
        }

        @Override
        public void applyRequestMetadata(
                RequestInfo requestInfo,
                Executor appExecutor,
                MetadataApplier applier)
        {
            Metadata headers = new Metadata();
            String value;
            if (type.getValuePrefix().isEmpty()) {
                value = token;
            } else {
                value = type.getValuePrefix() + token;
            }

            headers.put(type.getMetadataKey(), value);

            applier.apply(headers);
        }

        @Override
        public void thisUsesUnstableApi() {
        }
    }

    private static String getIamToken() throws IOException {
        Process exec = new ProcessBuilder().command("/home/uranix/yandex-cloud/bin/yc", "--profile", "preprod", "iam", "create-token").start();
        return IOUtils.toString(exec.getInputStream()).stripTrailing();
    }

    public static void main(String[] args) throws IOException {
        /*
        ManagedChannel authChannel = ManagedChannelBuilder
                .forAddress("as.private-api.cloud-preprod.yandex.net", 4286)
                .userAgent("Solomon")
                .enableRetry()
                .maxRetryAttempts(2)
                .build();

        Duration readTimeout = Duration.ofSeconds(15);

        AsyncCloudAuthClient cloudAuthGrpcClient = new AsyncCloudAuthGrpcClientImpl(
                authChannel,
                readTimeout,
                MoreExecutors.directExecutor()
        );

        var resp = join(cloudAuthGrpcClient.authorize(
                new IamToken(getIamToken()),
                "monitoring.quota.get",
                Resource.cloud("aoecngvoh58bgtr3s25a")));

        System.out.println(resp);
        System.exit(0);
         */

        ManagedChannel channel = ManagedChannelBuilder.forAddress("solomon-pre-front-sas-00.search.yandex.net", 5740)
                .usePlaintext()
                .build();

        var stub = YasmGatewayServiceGrpc.newBlockingStub(channel);

        var resp = stub.readData(ReadDataRequest.newBuilder()
                .addQueries(DataQuery.newBuilder()
                        .setFromMillis(Instant.now().minusSeconds(3600).toEpochMilli())
                        .setToMillis(Instant.now().minusSeconds(600).toEpochMilli())
                        .setTags("itype=balancer;prj=yasm")
                        .setExpression("sum(balancer_report-report-ambry-<5|4>xx-externalunknown_summ)")
                        .build())
                .build());
        System.out.println(resp);
    }
}
