package ru.yandex.solomon.experiments.uranix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.protobuf.LabelConverter;
import ru.yandex.solomon.labels.selector.LabelSelectorSet;
import ru.yandex.solomon.metabase.api.protobuf.Metric;
import ru.yandex.stockpile.api.MetricMeta;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ReadDump {
    public static final String PATH = "/home/uranix/noc/";

    public static void main(String[] args) throws IOException {
        Long2LongMap[] lastTsByLocalId = new Long2LongMap[4096];
        ObjectMapper mapper = new ObjectMapper();

        System.out.println("Reading SP");
        for (int i = 0; i < 4096; i++) {
            lastTsByLocalId[i] = new Long2LongOpenHashMap();
            File file = new File(PATH + "sp." + (i + 1) + ".pb.gz");
            if (!file.exists()) {
                continue;
            }
            var is = new GZIPInputStream(new FileInputStream(file));
            MetricMeta meta;
            while ((meta = MetricMeta.parseDelimitedFrom(is)) != null) {
                lastTsByLocalId[i].put(meta.getLocalId(), meta.getLastTsMillis());
            }
        }
        System.out.println("Reading SP done");

        System.out.println("Reading MB");
        var is = new GZIPInputStream(new FileInputStream(PATH + "mb.pb.gz"));
        Metric metric;

        var os = new PrintStream(new GZIPOutputStream(new FileOutputStream(PATH + "res.json.gz")));
        while ((metric = Metric.parseDelimitedFrom(is)) != null) {
            Labels labels = LabelConverter.protoToLabels(metric.getLabelsList());
            Map<String, Object> row = new HashMap<>(new LabelSelectorSet(labels).withoutShardKey().toLabels().toMap());
            var spId = metric.getMetricId();
            int shardId = spId.getShardId();
            long localId = spId.getLocalId();
            Long ts = lastTsByLocalId[shardId-1].get(Long.valueOf(localId));
            if (ts == null) {
                System.out.println("wtf");
            }
            row.put("$ts", ts);
            os.println(mapper.writeValueAsString(row));
        }
        os.close();
    }
}
