package ru.yandex.solomon.experiments.uranix;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

import ru.yandex.solomon.auth.Account;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.Authenticator;
import ru.yandex.solomon.auth.http.AuthMethodArgumentResolver;
import ru.yandex.solomon.auth.http.HttpAuthenticator;
import ru.yandex.solomon.auth.internal.InternalAuthorizer;
import ru.yandex.solomon.config.protobuf.ELevel;
import ru.yandex.solomon.config.protobuf.TLogger;
import ru.yandex.solomon.config.protobuf.TLoggingConfig;
import ru.yandex.solomon.config.protobuf.TThreadPoolConfig;
import ru.yandex.solomon.config.protobuf.TThreadPoolType;
import ru.yandex.solomon.config.protobuf.TThreadPoolsConfig;
import ru.yandex.solomon.config.protobuf.frontend.TAuthConfig;
import ru.yandex.solomon.config.protobuf.frontend.TGatewayConfig;
import ru.yandex.solomon.config.protobuf.frontend.TStaffOnlyConfig;
import ru.yandex.solomon.config.protobuf.http.HttpServerConfig;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.gateway.api.staffOnly.GlobalStaffOnlyController;
import ru.yandex.solomon.main.SolomonWebApp;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.secrets.SecretProviders;
import ru.yandex.solomon.staffOnly.StaffOnlyRedirectController;

@Configuration
@Import({
    StaffOnlyRedirectController.class,
    LazyThreadPoolProvider.class,
    ServicesTestApp.FakeAuthContext.class,
    GlobalStaffOnlyController.class,
})
public class ServicesTestApp extends SolomonWebApp {

    ServicesTestApp() {
        super(TGatewayConfig.getDefaultInstance());
    }

    @Override
    protected Message parseConfig(String[] args) {
        return TGatewayConfig.newBuilder()
            .setAuthConfig(TAuthConfig.newBuilder()
                .setTvmConfig(TAuthConfig.TTvmConfig.newBuilder()
                    .setClientId(2010240)
                    .setSecret("nonono")))
            .setHttpServerConfig(HttpServerConfig.newBuilder()
                .setBind("localhost")
                .setPort(7000)
                .setThreadsCount(2))
            .setThreadPoolsConfig(TThreadPoolsConfig.newBuilder()
                .addThreadPools(threadPool("FirstThreadPool", 3))
                .addThreadPools(threadPool("SecondThreadPool", 2))
                .addThreadPools(threadPool("Io", 1))
                .addThreadPools(threadPool("Scheduler", 1)))
            .setLoggingConfig(TLoggingConfig.newBuilder()
                .addLoggers(TLogger.newBuilder()
                    .setLevel(ELevel.INFO)
                    .setName("root")))
            .setStaffOnlyConfig(TStaffOnlyConfig.newBuilder()
                .addServices(TStaffOnlyConfig.TServiceConfig.newBuilder()
                    .setName("gateway")
                    .addAddresses("conductor_group://solomon_pre_gateway:4540")
                    .setAuthTvm(TStaffOnlyConfig.TServiceAuthTvm.newBuilder()
                        .setDstClientId(2010240)))
                .addServices(TStaffOnlyConfig.TServiceConfig.newBuilder()
                    .setName("fetcher")
                    .addAddresses("conductor_group://solomon_pre_fetcher:4520")
                    .addAddresses("conductor_group://solomon_prod_sts1_fetcher:4520")
                    .addAddresses("conductor_group://solomon_prod_sts2_fetcher:4520")
                    .setAuthTvm(TStaffOnlyConfig.TServiceAuthTvm.newBuilder()
                        .setDstClientId(2012024))
                    .setRootPage("/selfmon"))
                .addServices(TStaffOnlyConfig.TServiceConfig.newBuilder()
                    .setName("coremon")
                    .addAddresses("conductor_group://solomon_pre_fetcher:4510")
                    .setAuthTvm(TStaffOnlyConfig.TServiceAuthTvm.newBuilder()
                        .setDstClientId(2016579)))
                .addServices(TStaffOnlyConfig.TServiceConfig.newBuilder()
                    .setName("corecloud")
                    .addAddresses("conductor_group://cloud_preprod_solomon-core:4510")
                    .setAuthTvm(TStaffOnlyConfig.TServiceAuthTvm.newBuilder()
                            .setDstClientId(2016579))))
            .build();
    }

    @Configuration
    public static class FakeAuthContext implements WebFluxConfigurer {

        @Autowired
        private HttpAuthenticator authenticator;

        @Bean
        HttpAuthenticator httpAuthenticator() {
            return new HttpAuthenticator(Authenticator.anonymous());
        }

        @Bean
        InternalAuthorizer internalAuthorizer() {
            return new InternalAuthorizer(Set.of()) {
                @Override
                public CompletableFuture<Account> authorize(AuthSubject subject) {
                    return CompletableFuture.completedFuture(Account.ANONYMOUS);
                }
            };
        }

        @Override
        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            configurer.defaultCodecs().maxInMemorySize(50 << 20);
        }

        @Override
        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            configurer.addCustomResolver(new AuthMethodArgumentResolver(authenticator));
        }
    }

    @Override
    protected SecretProvider parseSecrets(String[] args) {
        return SecretProviders.empty();
    }

    private static TThreadPoolConfig threadPool(String name, int threads) {
        return TThreadPoolConfig.newBuilder()
            .setName(name)
            .setThreads(threads)
            .setThreadPoolType(TThreadPoolType.GENERAL)
            .build();
    }

    public static void main(String[] args) {
        new ServicesTestApp().run(args);
    }
}
