package ru.yandex.solomon.experiments.uranix;

import java.time.Instant;
import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.common.RequestProducer;
import ru.yandex.solomon.math.protobuf.Aggregation;
import ru.yandex.solomon.model.protobuf.MetricId;
import ru.yandex.solomon.tool.cfg.SolomonPorts;
import ru.yandex.stockpile.api.StockpileServiceGrpc;
import ru.yandex.stockpile.api.TReadRequest;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class StockpileGrpcClient {

    private static void show(GeneratedMessageV3 response) {
        System.out.println(response.getClass().getSimpleName() + ": " + response.toString());
    }

    public static void main(String[] args) throws InterruptedException {
        //ManagedChannel channel = ManagedChannelBuilder.forAddress("solomon-pre-alert-01.search.yandex.net", 8799)
        ManagedChannel channel = ManagedChannelBuilder.forAddress("localhost", SolomonPorts.STOCKPILE_GRPC)
                .usePlaintext()
                .build();

        var stpSertviceStub = StockpileServiceGrpc.newBlockingStub(channel);

        Instant from = Instant.parse("2020-01-17T12:07:52.496Z");
        Instant to = from.plusSeconds(3600);
        var read = TReadRequest.newBuilder()
                .setFromMillis(from.toEpochMilli())
                .setToMillis(to.toEpochMilli())
                .setMetricId(MetricId.newBuilder().setShardId(1016).setLocalId(1716194889648063525L).build())
                .setGridMillis(60_000)
                .setBinaryVersion(StockpileFormat.CURRENT.getFormat())
                .setAggregation(Aggregation.AVG)
                .setProducer(RequestProducer.SYSTEM)
                .build();

        show(stpSertviceStub.readCompressedOne(read));

        channel.shutdown().awaitTermination(5, TimeUnit.SECONDS);
    }
}
