package ru.yandex.solomon.experiments.uranix;

import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.discovery.DiscoveryService;
import ru.yandex.discovery.cluster.ClusterMapper;
import ru.yandex.discovery.cluster.ClusterMapperImpl;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.monitoring.gateway.DataQuery;
import ru.yandex.monitoring.gateway.ReadDataRequest;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.auth.AnonymousAuthSubject;
import ru.yandex.solomon.config.SolomonConfigs;
import ru.yandex.solomon.config.protobuf.frontend.TGatewayConfig;
import ru.yandex.solomon.config.protobuf.frontend.TYasmGatewayConfig;
import ru.yandex.solomon.config.thread.StubThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.conf.ShardConfDetailed;
import ru.yandex.solomon.core.conf.SolomonConfWithContext;
import ru.yandex.solomon.core.conf.SolomonRawConf;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.experiments.uranix.pmconf.PoorManConfDb;
import ru.yandex.solomon.flags.FeatureFlag;
import ru.yandex.solomon.flags.FeatureFlagHolderStub;
import ru.yandex.solomon.gateway.api.internal.yasm.YasmGatewayService;
import ru.yandex.solomon.gateway.api.internal.yasm.YasmGatewayServiceImpl;
import ru.yandex.solomon.gateway.data.DataClient;
import ru.yandex.solomon.gateway.data.DataClientMetrics;
import ru.yandex.solomon.main.logger.LoggerConfigurationUtils;
import ru.yandex.solomon.metrics.client.MetricsClient;
import ru.yandex.solomon.metrics.client.MetricsClientFactory;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class YasmGw {

    private MetricRegistry registry;
    private MetricsClient metricsClient;
    private DataClient dataClient;
    private YasmGatewayService yasmGw;

    private void dependency(String gatewayConfig, Supplier<SolomonRawConf> confSupplier) {
        TGatewayConfig config = SolomonConfigs.parseConfig(gatewayConfig, TGatewayConfig.getDefaultInstance());

        ThreadPoolProvider threadPool = new StubThreadPoolProvider();

        ClusterMapper clusterMapper = new ClusterMapperImpl(config.getClustersConfigList(), DiscoveryService.async(), threadPool.getExecutorService("", ""), threadPool.getSchedulerExecutorService());
        registry = new MetricRegistry();

        SolomonConfHolder confHolder = new SolomonConfHolder();
        confHolder.onConfigurationLoad(SolomonConfWithContext.create(confSupplier.get()));

        var clientOptionsFactory = new ClientOptionsFactory(Optional.empty(), Optional.empty(), threadPool);
        var metricsClientFactory = new MetricsClientFactory(threadPool, registry, clusterMapper, clientOptionsFactory);
        var flagsHolder = new FeatureFlagHolderStub();

        confHolder.getConf().getCorrectShardsStream()
                .map(ShardConfDetailed::getProject)
                .map(Project::getId)
                .distinct()
                .forEach(project -> flagsHolder.setFlag(project, FeatureFlag.SERIES_FROM_DATAPROXY, true));

        LoggerConfigurationUtils.disableLogger();

        metricsClient = metricsClientFactory.create(
                "yasm-gw",
                config.getMetabaseClientConfig(),
                config.getStockpileClientConfig(),
                config.getDataProxyClientConfig(),
                flagsHolder);
        dataClient = new DataClient(new DataClientMetrics(), metricsClient, clusterMapper, registry, confHolder, flagsHolder);
        yasmGw = new YasmGatewayServiceImpl(dataClient, null, TYasmGatewayConfig.newBuilder()
                .setYasmProjectsPrefix("yasm_pull_sts1_")
                .build());
    }

    private void run() throws IOException {
        dependency(
                //"/home/uranix/arcadia/solomon/configs/dev/gateway.dev.conf",
                "/home/uranix/arcadia/solomon/configs/prestable/gateway.conf",
                () -> PoorManConfDb.makeConfigForItype("yasm_pull_sts1_yasmagent", 10, 10)
        );


        while (true) {
            System.out.println("Press enter to send req");

            int ch = System.in.read();
            if (ch == 'q') {
                break;
            }

            long startMillis = System.currentTimeMillis();
            yasmGw.readData(ReadDataRequest.newBuilder()
                    .addQueries(DataQuery.newBuilder()
                            .setHosts("ASEARCH")
                            .setTags("itype=yasmagent;ctype=prod")
                            .setExpression("portoinst-anon_usage_gb_txxx")
                            .setFromMillis(Instant.parse("2021-03-01T18:00:00Z").toEpochMilli())
                            .setToMillis(Instant.parse("2021-03-02T18:00:00Z").toEpochMilli())
                            .setGridMillis(300_000)
                            .build())
                    .build(), AnonymousAuthSubject.INSTANCE)
                    .thenAccept(System.err::println)
                    .whenComplete((ignore, t) -> {
                        System.err.println("Elapsed: " + (System.currentTimeMillis() - startMillis) + " ms");
                    })
                    .join();
            System.err.println("done");
        }

        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        new YasmGw().run();
    }
}
