package ru.yandex.solomon.experiments.uranix.pmconf;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.conf.SolomonRawConf;
import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.DecimPolicy;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.Shard;
import ru.yandex.solomon.core.db.model.ShardSettings;
import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class PoorManConfDb {
    public static SolomonRawConf makeConfigForShard(ShardKey shard) {
        return new SolomonRawConf(
                List.of(),
                List.of(Project.newBuilder()
                        .setOwner("golovan")
                        .setName("")
                        .setId(shard.getProject())
                        .build()),
                List.of(Cluster.newBuilder()
                        .setId("awesome_cluster")
                        .setName(shard.getCluster())
                        .setProjectId(shard.getProject())
                        .build()),
                List.of(Service.newBuilder()
                        .setId("awesome_service")
                        .setName(shard.getService())
                        .setProjectId(shard.getProject())
                        .build()),
                List.of(Shard.newBuilder()
                        .setId("awesome_shard")
                        .setProjectId(shard.getProject())
                        .setClusterId("awesome_cluster")
                        .setClusterName(shard.getCluster())
                        .setServiceId("awesome_service")
                        .setServiceName(shard.getService())
                        .build())
        );
    }

    public static SolomonRawConf makeConfigForItype(String project, int groupShards, int hostShards) {
        return new SolomonRawConf(
                List.of(),
                List.of(Project.newBuilder()
                        .setOwner("golovan")
                        .setName("")
                        .setId(project)
                        .build()),
                Stream.concat(
                        IntStream.range(0, groupShards)
                                .mapToObj(i -> Cluster.newBuilder()
                                        .setId(project + "_group_" + i)
                                        .setName("group_" + i)
                                        .setProjectId(project)
                                        .build()),
                        IntStream.range(0, hostShards)
                                .mapToObj(i -> Cluster.newBuilder()
                                        .setId(project + "_host_" + i)
                                        .setName("host_" + i)
                                        .setProjectId(project)
                                        .build()))
                        .collect(Collectors.toList()),
                List.of(Service.newBuilder()
                        .setId(project)
                        .setName("yasm")
                        .setProjectId(project)
                        .setShardSettings(ShardSettings.of(ShardSettings.Type.PULL,
                                 ShardSettings.PullSettings.newBuilder().build(),
                                0,
                                0,
                                DecimPolicy.UNDEFINED,
                                ShardSettings.AggregationSettings.EMPTY,
                                5))
                        .build()),
                Stream.concat(
                        IntStream.range(0, groupShards)
                                .mapToObj(i -> Shard.newBuilder()
                                        .setId(project + "_group_" + i)
                                        .setProjectId(project)
                                        .setClusterId(project + "_group_" + i)
                                        .setClusterName("group_" + i)
                                        .setServiceId(project)
                                        .setServiceName("yasm")
                                        .setNumId((project + "_group_" + i).hashCode())
                                        .build()),
                        IntStream.range(0, hostShards)
                                .mapToObj(i -> Shard.newBuilder()
                                        .setId(project + "_host_" + i)
                                        .setProjectId(project)
                                        .setClusterId(project + "_host_" + i)
                                        .setClusterName("host_" + i)
                                        .setServiceId(project)
                                        .setServiceName("yasm")
                                        .setNumId((project + "_host_" + i).hashCode())
                                        .build()))
                        .collect(Collectors.toList())
        );
    }
}
