package ru.yandex.solomon.experiments.uranix.ualerting;

import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.logging.log4j.Level;

import ru.yandex.discovery.cluster.ClusterMapper;
import ru.yandex.discovery.cluster.ClusterMapperContext;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.monlib.metrics.labels.string.StringLabelAllocator;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.SolomonConfigs;
import ru.yandex.solomon.config.protobuf.alert.TAlertingConfig;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.flags.FeatureFlagHolderStub;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.solomon.labels.query.SelectorsFormat;
import ru.yandex.solomon.main.logger.LoggerConfigurationUtils;
import ru.yandex.solomon.metrics.client.MetricsClient;
import ru.yandex.solomon.metrics.client.MetricsClientContext;
import ru.yandex.solomon.metrics.client.combined.FindAndReadManyRequest;

public class MicroAlerting {

    private final MetricRegistry registry = MetricRegistry.root();
    private ThreadPoolProvider threadPoolProvider;
    private ClusterMapper clusterMapper;
    private MetricsClientContext metricsClientContext;
    private FeatureFlagsHolder flagsHolder;
    private MetricsClient metricsClient;

    public static void main(String[] args) throws IOException, InterruptedException {
        new MicroAlerting().run(args);
    }

    public void run(String[] args) throws IOException, InterruptedException {
        String path = "/home/uranix/arcadia/solomon/configs/production/alerting.conf";
        var config = SolomonConfigs.parseConfig(path, TAlertingConfig.getDefaultInstance());

//        LoggerConfigurationUtils.configureLogger(config.getLoggingConfig());
        LoggerConfigurationUtils.simpleLogger(Level.DEBUG);

        threadPoolProvider = new LazyThreadPoolProvider(config.getThreadPoolsConfig());
        clusterMapper = new ClusterMapperContext().clusterMapper(config.getClustersConfigList(), threadPoolProvider);
        ClientOptionsFactory clientOptionsFactory = new ClientOptionsFactory(Optional.empty(), Optional.empty(), threadPoolProvider);
        metricsClientContext = new MetricsClientContext(
                threadPoolProvider, registry, clusterMapper,
                Optional.of(StringLabelAllocator.SELF), Optional.empty(), clientOptionsFactory);
        flagsHolder = new FeatureFlagHolderStub();
        var mcc = config.getMetabaseClientConfig().toBuilder()
//                .clearFindCacheConfig()
                .build();
        metricsClient = metricsClientContext.metricsClient(
                config.getClientId(), mcc, config.getStockpileClientConfig(),
                Optional.empty(), Optional.of(flagsHolder)
        );
        var pool = threadPoolProvider.getExecutorService("CpuLowPriority", "whatever");
        AtomicInteger respCount = new AtomicInteger(0);
        for (;;) {
            try {
                Thread.sleep(10);
                pool.submit(() -> {
                    try {
                        Instant now = Instant.now();
                        var resp = metricsClient.findAndReadMany(FindAndReadManyRequest.newBuilder()
                                .setSelectors(SelectorsFormat.parse("{project=solomon, service=coremon, cluster=production, host=cluster, sensor=jvm.runtime.uptime}"))
                                .setFromMillis(now.minusSeconds(300).toEpochMilli())
                                .setToMillis(now.toEpochMilli())
    //                            .setDestination("sas")
                                .build()).join();
                        if (!resp.isOk()) {
                            return;
                        }
                        if (resp.getMetrics().size() == 0) {
                            System.out.println("gotcha");
                        } else {
                            if (respCount.incrementAndGet() == 1000) {
                                System.exit(0);
                            }
                        }
                    } catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                });
            } catch (Exception e) {
                Thread.sleep(100);
            }
        }
    }

}
