package ru.yandex.solomon.experiments.alexlovkov;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.misc.random.Random2;

/**
 * @author alexlovkov
 */
public class TrieTest {


    @Test
    public void testTrie() {
        Trie trie = new Trie();

        trie.insert(new String[]{"a", "b"});
        trie.insert(new String[]{"a", "b", "c"});
        trie.insert(new String[]{"f", "e"});

        Assert.assertTrue(trie.find(new String[]{"a","b"}));
        Assert.assertTrue(trie.find(new String[]{"a","b","c"}));
        Assert.assertTrue(trie.find(new String[]{"f","e"}));

        Assert.assertFalse(trie.find(new String[]{"a"}));
        Assert.assertFalse(trie.find(new String[]{"a","b","d"}));
        Assert.assertFalse(trie.find(new String[]{"a","f","e"}));
        Assert.assertFalse(trie.find(new String[]{"b","a"}));
        Assert.assertFalse(trie.find(new String[]{"b","c"}));
    }

    @Test
    public void test() {
        Trie trie = new Trie();
        Random2 random2 = new Random2();

        for (int i = 0; i < 10; i++) {
            String s = "a b " + random2.nextChar();
            String s2 = "a c d " + random2.nextChar();
            trie.insert(s2.split(" "));
            trie.insert(s.split(" "));
        }
        trie.analyze();
    }
}
