package ru.yandex.solomon.experiments.gordiychuk.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

import ru.yandex.stockpile.server.shard.load.Async;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static ru.yandex.solomon.experiments.gordiychuk.recovery.Records.randomRecord;

/**
 * @author Vladimir Gordiychuk
 */
public class AsyncRecordReaderTest {

    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    private Path target;

    @Before
    public void setUp() throws IOException {
        target = tmp.newFile().toPath();
    }

    @Test
    public void empty() {
        var reader = reader();
        assertNull(reader.next().join());
        assertNull(reader.next().join());
        assertNull(reader.next().join());
    }

    @Test
    public void one() {
        var expected = randomRecord();
        try (var writer = writer()) {
            writer.write(expected);
        }

        var reader = reader();
        assertEquals(expected, reader.next().join());
    }

    @Test
    public void many() {
        List<Record> expected = IntStream.range(0, 100_000)
            .mapToObj(ignore -> randomRecord())
            .collect(Collectors.toList());

        try (var writer = writer()) {
            expected.forEach(writer::write);
        }

        var reader = reader();
        AtomicInteger index = new AtomicInteger();
        Async.forEach(reader::next, record -> {
            assertEquals(expected.get(index.getAndIncrement()), record);
        }).join();

        assertEquals(index.get(), expected.size());
        assertNull(reader.next().join());
    }

    public RecordWriter writer() {
        return new RecordWriter(target);
    }

    public AsyncRecordReader reader() {
        return new AsyncRecordReader(target);
    }
}
