package ru.yandex.solomon.experiments.gordiychuk.recovery;

import org.junit.Test;

import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileShardId;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.experiments.gordiychuk.recovery.Records.randomRecord;

/**
 * @author Vladimir Gordiychuk
 */
public class RecordTest {

    @Test
    public void compareSame() {
        Record left = new Record();
        left.labels = "&name=001&";
        left.shardId = StockpileShardId.random();
        left.localId = StockpileLocalId.random();

        Record right = new Record();
        right.labels = "&name=001&";
        right.shardId = StockpileShardId.random();
        right.localId = StockpileLocalId.random();

        assertEquals(0, left.compareTo(right));
        assertEquals(0, right.compareTo(left));
    }

    @Test
    public void compareDifferentLabel() {
        Record left = new Record();
        left.labels = "&name=001&";
        left.shardId = StockpileShardId.random();
        left.localId = StockpileLocalId.random();

        Record right = new Record();
        right.labels = "&name=002&";
        right.shardId = StockpileShardId.random();
        right.localId = StockpileLocalId.random();

        assertEquals(-1, left.compareTo(right));
        assertEquals(1, right.compareTo(left));
    }

    @Test
    public void randomSeqGrow() {
        Record one = randomRecord();
        Record two = randomRecord();
        Record tree = randomRecord();

        assertEquals(-1, one.compareTo(two));
        assertEquals(-1, two.compareTo(tree));
    }
}
