package ru.yandex.solomon.experiments.gordiychuk.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.IntStream;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static ru.yandex.solomon.experiments.gordiychuk.recovery.Records.randomRecord;

/**
 * @author Vladimir Gordiychuk
 */
public class RecordWriterTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @Rule
    public TestName testName = new TestName();

    private Path target;
    private RecordWriter writer;

    @Before
    public void setUp() throws IOException {
        String name = testName.getMethodName();
        target = tmp.newFile(name).toPath();
        writer = new RecordWriter(target);
    }

    @Test
    public void writeMany() {
        IntStream.range(0, 100).forEach(index -> writer.write(randomRecord()));

        writer.close();

        int cnt = 0;
        try (RecordIterator it = new RecordIterator(target)) {
            while (it.next() != null) {
                cnt++;
            }
        }
        assertEquals(100, cnt);
    }

    @Test
    public void writeInvalidChar() {
        var one = randomRecord();
        one.labels = "&host=iva5-s107&ifname=Office IIX для устройств, не имеющих пр&sensor=rx&";

        var two = randomRecord();
        two.labels = "&host=cluster&ifalias=Office IIX для устройств, не имеющих пррP\u001D82\u007F&ifname=vlan402&sensor=rx";
        writer.write(one);
        writer.write(two);
        writer.close();

        try (var it = new RecordIterator(target)) {
            assertEquals(one, it.next());
            assertNull(it.next());
        }
    }
}
