package ru.yandex.solomon.experiments.gordiychuk.recovery;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileShardId;

/**
 * @author Vladimir Gordiychuk
 */
public class Records {
    private static AtomicLong index = new AtomicLong();

    public static Record randomRecord() {
        Record record = new Record();
        record.flags = 0;
        record.labels = String.format("&name=%09d&", index.incrementAndGet());
        record.shardId = StockpileShardId.random();
        record.localId = StockpileLocalId.random();
        record.createdAtSeconds = nowSeconds();
        return record;
    }

    public static MappingRecord randomMappingRecord() {
        var record = new MappingRecord();
        record.localLocalId = StockpileLocalId.random();
        record.remoteShardId = StockpileShardId.random();
        record.remoteLocalId = StockpileLocalId.random();
        return record;
    }

    private static long nowSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - TimeUnit.DAYS.toSeconds(10);
    }
}
