package ru.yandex.solomon.experiments.gordiychuk.recovery.metabase;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.solomon.experiments.gordiychuk.recovery.RecordIterator;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.tool.YdbClient;
import ru.yandex.solomon.tool.YdbHelper;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static ru.yandex.solomon.experiments.gordiychuk.recovery.Records.randomRecord;

/**
 * @author Vladimir Gordiychuk
 */
@YaIgnore
public class DumpMetricsFromClusterTaskTest {
    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();

    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Rule
    public TestName testName = new TestName();

    private YdbClient ydb;
    private String root;
    private DumpMetricsFromClusterTask task;
    private Path target;

    @Before
    public void setUp() throws IOException {
        root = localKikimr.getRoot().resolve(testName.getMethodName()).toString();
        target = folder.newFolder().toPath();
        var endpoint = localKikimr.getGrpcEndpoint();
        ydb = YdbHelper.createYdbClient(endpoint);
        task = new DumpMetricsFromClusterTask(root, target, ydb, ForkJoinPool.commonPool());
    }

    @Test
    public void emptyShards() {
        MetabaseUtils.createSchema(ydb, root, "alice");
        MetabaseUtils.createSchema(ydb, root, "bob");
        MetabaseUtils.createSchema(ydb, root, "eva");
        task.run();

        for (String shardId : List.of("alice", "bob", "eva")) {
            try (var it = new RecordIterator(target.resolve("metrics").resolve(shardId))) {
                assertNull(it.next());
            }
        }
    }

    @Test
    public void processedAllShards() {
        var records = IntStream.range(0, 15)
            .mapToObj(ignore -> randomRecord())
            .collect(Collectors.toList());

        {
            int index = 0;
            for (var record : records) {
                String shardId = String.format("%09d", index++);
                MetabaseUtils.createSchema(ydb, root, shardId);
                MetabaseUtils.insert(ydb, root, shardId, record);
            }
        }

        task.run();

        for (int index = 0; index < records.size(); index++) {
            try (var it = new RecordIterator(target.resolve("metrics").resolve(String.format("%09d", index)))) {
                assertEquals(records.get(index), it.next());
                assertNull(it.next());
            }
        }
    }
}
