package ru.yandex.solomon.experiments.gordiychuk.recovery.metabase;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

import ru.yandex.devtools.test.annotations.YaIgnore;
import ru.yandex.solomon.experiments.gordiychuk.recovery.Record;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.tool.YdbClient;
import ru.yandex.solomon.tool.YdbHelper;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.experiments.gordiychuk.recovery.Records.randomRecord;

/**
 * @author Vladimir Gordiychuk
 */
@YaIgnore
public class MetabaseShardMetricsReaderTest {
    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();

    private YdbClient ydb;
    private MetabaseShardMetricsReader reader;
    private String root;

    @Before
    public void setUp() {
        root = localKikimr.getRoot().resolve(testName.getMethodName()).toString();
        ydb = YdbHelper.createYdbClient(localKikimr.getGrpcEndpoint());
        reader = new MetabaseShardMetricsReader(root, ydb, "alice", 0);
        MetabaseUtils.createSchema(ydb, root, "alice");
    }

    @Test
    public void readEmpty() {
        List<Record> list = new ArrayList<>();
        reader.run(list::add).join();

        assertEquals(List.of(), list);
    }

    @Test
    public void readOne() {
        Record record = randomRecord();
        insert(record);

        List<Record> list = new ArrayList<>();
        reader.run(list::add).join();

        assertEquals(List.of(record), list);
    }

    @Test
    public void readManyOrdered() {
        List<Record> records = IntStream.range(0, 150_000)
            .mapToObj(index -> randomRecord())
            .sorted(Record::compareTo)
            .collect(Collectors.toList());
        insert(records);

        List<Record> list = new ArrayList<>(50_000);
        reader.run(list::add).join();

        assertArrayEquals(records.toArray(), list.toArray());
    }

    private void insert(Record record) {
        insert(List.of(record));
    }

    private void insert(List<Record> records) {
        MetabaseUtils.insert(ydb, root, "alice", records);
    }
}
