package ru.yandex.solomon.experiments.uranix;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

import ru.yandex.solomon.alert.notification.channel.telegram.ChatIdStorage;

/**
 * @author Ivan Tsybulin
 */
class ChatIdStorageStub implements ChatIdStorage {

    private final BiMap<String, Long> chatIdByLogin = HashBiMap.create();
    private final BiMap<String, Long> chatIdByGroupTitle = HashBiMap.create();

    @Override
    public long getChatIdByTelegramLogin(String name) {
        return Optional.ofNullable(chatIdByLogin.get(name)).orElse(0L);
    }

    @Override
    public long getChatIdByGroupTitle(String groupTitle) {
        return Optional.ofNullable(chatIdByGroupTitle.get(groupTitle)).orElse(0L);
    }

    @Override
    public String resolveGroupTitle(long chatId) {
        return chatIdByGroupTitle.inverse().get(chatId);
    }

    @Override
    public CompletableFuture<Void> loadAll() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void removeTelegramLogin(String telegramLogin) {
        chatIdByLogin.remove(telegramLogin);
    }

    @Override
    public void removeGroupTitle(String groupChat) {
        chatIdByGroupTitle.remove(groupChat);
    }

    @Override
    public void addTelegramLogin(long chatId, String login) {
        chatIdByLogin.put(login, chatId);
    }

    @Override
    public void addGroupTitle(long chatId, String groupTitle) {
        chatIdByGroupTitle.put(groupTitle, chatId);
    }

    @Override
    public List<String> listGroups() {
        return new ArrayList<>(chatIdByGroupTitle.keySet());
    }
}
