JAVA_PROGRAM(solomon-experiments)

OWNER(g:solomon)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/contribs.inc)

ANNOTATION_PROCESSOR(org.openjdk.jmh.generators.BenchmarkProcessor)

PEERDIR(
    solomon/graphite/mega-graphite-storage
    solomon/libs/java/conf-db
    solomon/libs/java/main
    solomon/libs/java/search-index
    solomon/tools/misc-tools

    solomon/services/alerting/bin
    solomon/services/dumper/bin
    solomon/services/gateway/bin
    solomon/services/stockpile/bin

    iceberg/misc-cmdline
    iceberg/inside-solomon
    iceberg/inside-yt

    contrib/java/org/slf4j/slf4j-api

    contrib/java/org/openjdk/jmh/jmh-core
    contrib/java/org/openjdk/jmh/jmh-generator-annprocess
    contrib/java/org/apache/commons/commons-io/1.3.2
    contrib/java/org/xerial/snappy/snappy-java/1.1.0.1
    contrib/java/org/antlr/antlr4
    contrib/java/org/hdrhistogram/HdrHistogram/2.1.12

    solomon/protos/api/v3/project/manager
)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/jdk.inc)

JAVA_SRCS(
    PACKAGE_PREFIX ru.yandex.solomon.experiments
    SRCDIR src
    **/*.java
)

EXCLUDE(${service_excludes})

JVM_ARGS(
    -Dru.yandex.solomon.LabelValidator=skip
    -Djava.net.preferIPv6Addresses=true
)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/org/antlr/antlr4/4.7.1
)

LINT(base)
END()

RECURSE_FOR_TESTS(ut)
