#!/bin/bash -e

BIN_DIR="$(dirname $(readlink -f $0))"
CLASS_PATH="${BIN_DIR}/libs/*"

. "${BIN_DIR}/../../solomon/etc/java.sh"

DEBUG="-Xdebug -Xverify:none -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=32151"

HEAP_SIZE=150g

cd ${BIN_DIR}
exec ${JAVA} \
     -classpath "${CLASS_PATH}" \
     -showversion -server \
     -Xmx$HEAP_SIZE \
     --enable-preview \
     -Xlog:gc*:file="/Berkanavt/mega-graphite/logs/storage-gc.log":time:filecount=2,filesize=50M -Xlog:gc+ergo \
     -Xlog:safepoint:file="/Berkanavt/mega-graphite/logs/storage-safepoints.log"::filecount=2,filesize=50M \
     -XX:+UseParallelGC \
     -XX:OnOutOfMemoryError="kill -9 %p" \
     -Dhost.name=`/bin/hostname` \
     -Djava.net.preferIPv6Addresses=true \
     ru.yandex.market.graphouse.MegaGraphiteMain "$@"
