#!/bin/sh -x

SETTINGS_FILE="/Berkanavt/mega-graphite/web/webapp/graphite/local_settings.py"

RED='\033[1;31m'
NC='\033[0m' # No Color

ENVIRONMENT=$(cat /etc/yandex/environment.type 2>/dev/null)

DB_NAME="graphite"
DB_USER="graphite"
DB_PASS="etihparg"
DB_PORT="3306"
USE_YANDEX_HEADER="False"

CLUSTER=$(hostname | awk 'gsub(/^(mega-)?graphite|(man|sas|vla)-(00|01|02).(search|mon).yandex.net$/, "") {print (/^-(bs-)?$/) ? "bs" : (/^-gr-$/) ? "gr" : (/^-ps-$/) ? "ps" : ""}')

case "$ENVIRONMENT" in
    "production")
        DB_HOST="::1"
        DB_PORT="3306"
        DB_PASS=$(awk 'sub(/graphite-web:/, "")' /Berkanavt/keys/graphite/mysql.secrets)
        case "$CLUSTER" in
            "bs")
                DB_USER="graphite-web"
                DB_NAME="graphite_bs"
                ;;
            "gr")
                DB_USER="graphite-web"
                DB_NAME="graphite_gr"
                USE_YANDEX_HEADER="True"
                ;;
            "ps")
                DB_USER="graphite-web"
                DB_NAME="graphite_ps"
                ;;
            *)
                echo "${RED}Failed to detect cluster for graphite-web installation. Graphite-web won't be able to connect to the DB!${NC}" 1>&2
                ;;
        esac
        ;;
    "testing")
        DB_HOST="localhost"
        DB_PORT="3306"
        DB_USER="graphite-web-tt"
        DB_NAME="graphite_tt"
        DB_PASS=""
        ;;
    *)
        DB_HOST="UNKNOWN"
        DB_PORT="UNKNOWN"
        DB_NAME="UNKNOWN"
        DB_USER="UNKNOWN"
        DB_PASS="UNKNOWN"
        echo "${RED}Failed to detect Nginx and DB settings for the local graphite-web installation. Graphite-web won't be able to connect to the DB!${NC}" 1>&2
        ;;
esac

sed -i "
    s/CLUSTER_DB_HOST_PLACEHOLDER/${DB_HOST}/;
    s/CLUSTER_DB_PORT_PLACEHOLDER/${DB_PORT}/;
    s/CLUSTER_DB_NAME_PLACEHOLDER/${DB_NAME}/;
    s/CLUSTER_DB_USER_PLACEHOLDER/${DB_USER}/;
    s/CLUSTER_DB_PASS_PLACEHOLDER/${DB_PASS}/;
    s/CLUSTER_USE_YANDEX_HEADER_PLACEHOLDER/${USE_YANDEX_HEADER}/;
" $SETTINGS_FILE

chmod 640 $SETTINGS_FILE
