TIME_ZONE = 'Europe/Moscow'

DOCUMENTATION_URL = 'http://graphite.readthedocs.org/'

DEFAULT_CACHE_DURATION = 300

LOG_RENDERING_PERFORMANCE = True
LOG_CACHE_PERFORMANCE = False
LOG_METRIC_ACCESS = True

GRAPHITE_ROOT = '/Berkanavt/mega-graphite/web'

CONF_DIR = '/Berkanavt/mega-graphite/web/conf'
STORAGE_DIR = '/Berkanavt/mega-graphite/web/storage'
CONTENT_DIR = '/Berkanavt/mega-graphite/web/webapp/content'

DASHBOARD_CONF = '/Berkanavt/mega-graphite/web/conf/dashboard.conf'
GRAPHTEMPLATES_CONF = '/Berkanavt/mega-graphite/web/conf/graphTemplates.conf'

CERES_DIR = '/Berkanavt/mega-graphite/web/storage/ceres'
LOG_DIR = '/Berkanavt/mega-graphite/logs'
INDEX_FILE = '/Berkanavt/mega-graphite/web/storage/index'  # Search index file
DATABASES = {
        'default': {
# These placeholders are replaced in postinst script with values actual for the current host
                'NAME': 'CLUSTER_DB_NAME_PLACEHOLDER',
                'ENGINE': 'django.db.backends.mysql',
                'USER': 'CLUSTER_DB_USER_PLACEHOLDER',
                'PASSWORD': 'CLUSTER_DB_PASS_PLACEHOLDER',
                'HOST': 'CLUSTER_DB_HOST_PLACEHOLDER',
                'PORT': 'CLUSTER_DB_PORT_PLACEHOLDER',
                'CONN_MAX_AGE': None
        }
}

SECRET_KEY = "e89c81ba4ffc32d541122165a4d1dd07"

REMOTE_FIND_TIMEOUT = 5.0              # Timeout for metric find requests
REMOTE_FETCH_TIMEOUT = 10.0            # Timeout to fetch series data
REMOTE_RETRY_DELAY = 20.0              # Time before retrying a failed remote webapp
REMOTE_READER_CACHE_SIZE_LIMIT = 10000 # Maximum number of remote URL queries to cache
FIND_CACHE_DURATION = 600              # Time to cache remote metric find results
FIND_TOLERANCE = 2 * FIND_CACHE_DURATION
RENDER_DURATION_TIMEOUT = 180

#MEMCACHE_HOSTS = [ '127.0.0.1:11211' ]

STOCKPILE_SERVER = '127.0.0.1'
USE_PASSPORT_USER_AUTHENTICATION = True
CLUSTER_SERVERS = [ '127.0.0.1' ]
#GRAPHITE_HOSTS = [
#        'bsgraphite-front01i.yandex.ru',
#        'bsgraphite-front01h.yandex.ru',
#        'bsgraphite-front01g.yandex.ru',
#        'bsgraphite-front01e.yandex.ru'
#]

STORAGE_FINDERS = (
        'graphite.stockpile.StockpileFinder',
)

USE_YANDEX_HEADER = CLUSTER_USE_YANDEX_HEADER_PLACEHOLDER
