package GraphiteAPI;

use strict;
use warnings;

use IO::Socket::INET;

our $pid_socket = {};

sub send {
	my $metrica = shift;
	my $value = shift;
	my $time = shift || time();

	return unless ($metrica && defined($value));

	if (!$pid_socket->{$$} || !$pid_socket->{$$}->connected()) {
		$pid_socket->{$$} = IO::Socket::INET->new(
			PeerAddr => 'localhost',
			PeerPort => 42000,
			Proto => 'tcp',
			Timeout => 50,
			Type => SOCK_STREAM,
		)
		or return;
	}

	my $socket = $pid_socket->{$$};
	printf($socket "%s %s %s\n", $metrica, $value, $time);

	return 1;
}

1
