import re
import os
import math
import time

import system


def BucketRemove(ValueDictsList, Nmax, Vmax, Smin, Err=1e-5):
    '''
        ValueDictsList = [{"Value": VALUE, ...}, ...]
        Nmax - maximum number of elements to keep in the List
        Vmax - upper limit for VALUE to keep
        Smin - minumum first bucket size: [0; Smin). Rule of thumb: it should be SMALLER than the usual distance between VALUEs
    '''
    Err *= Vmax
    VmaxTest = 0
    A = Smin/(math.pow(Vmax/Smin, 1.0/(Nmax - 1)) - 1)
    while abs(Vmax - VmaxTest) > Err:
        k = math.log(Vmax/A + 1)/Nmax
        A = Smin/(math.exp(k) - 1)
        VmaxTest = A*(math.exp(k*Nmax) - 1)
    BucketLimitsList    = [A*(math.exp(k*V) - 1) for V in xrange(Nmax + 1)]
    RemoveList          = [V for V in ValueDictsList if V["Value"] > BucketLimitsList[-1]]
    RemoveCounter       = len(ValueDictsList) - len(RemoveList) - Nmax
    if RemoveCounter <= 0:
        return RemoveList
    Idx = Nmax
    CountPerBucket = 0
    ValueDictsSortedList = sorted(ValueDictsList, cmp=lambda x,y: cmp(x["Value"], y["Value"]), reverse=True)
    for V in ValueDictsSortedList[len(RemoveList):]:
        while True:
            if V["Value"] >= BucketLimitsList[Idx]:
                if CountPerBucket > 0:
                    RemoveList.append(V)
                    RemoveCounter -= 1
                    if RemoveCounter == 0:
                        return RemoveList
                else:
                    CountPerBucket += 1
                break
            else:
                Idx -= 1
                CountPerBucket = 0
    return RemoveList


def DirCleanup(Dir, Pattern, SkipTimeHours=24, SizeGB=10, MaxFileCount=100):
    system.Log("Cleaning up dir %s (to %s GB, >%s hours)" % (Dir, SizeGB, SkipTimeHours))
    rePattern   = re.compile("^%s$" % Pattern)
    Time        = time.time() - SkipTimeHours*3600
    Size        = SizeGB*1024*1024*1024
    Count       = MaxFileCount
    ItemList    = []
    DeleteList  = []
    for Item in os.listdir(Dir):
        if not rePattern.match(Item):
            continue
        ItemPath = os.path.join(Dir, Item)
        ItemStat = os.stat(ItemPath)
        if not os.path.isfile(ItemPath) or ItemStat.st_mtime > Time:
            continue
        ItemList.append({
            "Path": ItemPath,
            "Size": ItemStat.st_size,
            "Time": ItemStat.st_mtime
        })
    for Item in sorted(ItemList, cmp=lambda x,y: cmp(x["Time"], y["Time"]), reverse=True):
        Size    -= Item["Size"]
        Count   -= 1
        if Size < 0 or Count < 0:
            DeleteList.append(Item)
    for Item in DeleteList:
        system.Log("Removing file %s (size=%s MB) ..." % (Item["Path"], Item["Size"]/1024/1024))
        os.unlink(Item["Path"])
